package repository

import (
	"fmt"

	"github.com/golang/protobuf/proto"

	"a.yandex-team.ru/travel/proto/dicts/rasp"
)

type ThreadRepository struct {
	thread map[int32]*rasp.TThread
}

func NewThreadRepository() *ThreadRepository {
	return &ThreadRepository{
		thread: make(map[int32]*rasp.TThread),
	}
}

func (tr *ThreadRepository) Add(message proto.Message) {
	thread := message.(*rasp.TThread)
	tr.thread[thread.Id] = thread
}

func (tr *ThreadRepository) Write(b []byte) (int, error) {
	thread := &rasp.TThread{}
	if err := proto.Unmarshal(b, thread); err != nil {
		return 0, fmt.Errorf("ThreadRepository:Write: %w", err)
	}
	tr.Add(thread)
	return len(b), nil
}

func (tr *ThreadRepository) Get(id int) (*rasp.TThread, bool) {
	thread, ok := tr.thread[int32(id)]
	return thread, ok
}

func (tr *ThreadRepository) DeserializeRow(row []byte) (*rasp.TThread, error) {
	code := &rasp.TThread{}
	if err := proto.Unmarshal(row, code); err != nil {
		return nil, fmt.Errorf("ThreadRepository:DeserializeRow: %w", err)
	}
	return code, nil
}
