package repository

import (
	"fmt"

	"github.com/golang/protobuf/proto"

	"a.yandex-team.ru/travel/proto/dicts/rasp"
)

type ThreadStationRepository struct {
	stations map[int]*rasp.TThreadStation
}

func NewThreadStationRepository() *ThreadStationRepository {
	return &ThreadStationRepository{
		stations: make(map[int]*rasp.TThreadStation)}
}

func (tr *ThreadStationRepository) Add(message proto.Message) {
	station := message.(*rasp.TThreadStation)
	tr.stations[int(station.Id)] = station
}

func (tr *ThreadStationRepository) Write(b []byte) (int, error) {
	station := &rasp.TThreadStation{}
	if err := proto.Unmarshal(b, station); err != nil {
		return 0, fmt.Errorf("ThreadStationRepository:Write: %w", err)
	}
	tr.Add(station)
	return len(b), nil
}

func (tr *ThreadStationRepository) Get(id int) (*rasp.TThreadStation, bool) {
	station, ok := tr.stations[id]
	return station, ok
}

func (tr *ThreadStationRepository) DeserializeRow(row []byte) (*rasp.TThreadStation, error) {
	station := &rasp.TThreadStation{}
	if err := proto.Unmarshal(row, station); err != nil {
		return nil, fmt.Errorf("ThreadStationRepository:DeserializeRow: %w", err)
	}
	return station, nil
}
