package repository

import (
	"fmt"

	"github.com/golang/protobuf/proto"

	"a.yandex-team.ru/travel/proto/dicts/rasp"
)

type TimeZoneRepository struct {
	timezones map[int32]*rasp.TTimeZone
}

func NewTimeZoneRepository() *TimeZoneRepository {
	return &TimeZoneRepository{
		timezones: make(map[int32]*rasp.TTimeZone)}
}

func (tzr *TimeZoneRepository) Write(b []byte) (int, error) {
	timeZone := &rasp.TTimeZone{}
	if err := proto.Unmarshal(b, timeZone); err != nil {
		return 0, fmt.Errorf("TimeZoneRepository:Write: %w", err)
	}
	tzr.timezones[timeZone.Id] = timeZone
	return len(b), nil
}

func (tzr *TimeZoneRepository) Get(id int) (*rasp.TTimeZone, bool) {
	timezone, ok := tzr.timezones[int32(id)]
	return timezone, ok
}
