package errorbooster

type AdditionalData struct {
	Vertical   string `json:"vertical,omitempty"`
	Service    string `json:"service,omitempty"`
	Datacenter string `json:"datacenter,omitempty"`
}

type Message struct {
	Stack        string                 `json:"stack,omitempty"`
	Dc           string                 `json:"dc,omitempty"`
	Level        string                 `json:"level,omitempty"`
	Slots        string                 `json:"slots,omitempty"`
	ReqID        string                 `json:"reqid,omitempty"`
	Method       string                 `json:"method,omitempty"`
	Source       string                 `json:"source,omitempty"`
	SourceMethod string                 `json:"sourceMethod,omitempty"`
	SourceType   string                 `json:"sourceType,omitempty"`
	IsInternal   string                 `json:"isInternal,omitempty"`
	IsRobot      string                 `json:"isRobot,omitempty"`
	Host         string                 `json:"host,omitempty"`
	File         string                 `json:"file,omitempty"`
	Message      string                 `json:"message"`
	Project      string                 `json:"project"`
	Service      string                 `json:"service,omitempty"`
	IP           string                 `json:"ip,omitempty"`
	Experiments  string                 `json:"experiments,omitempty"`
	Platform     string                 `json:"platform,omitempty"`
	Block        string                 `json:"block,omitempty"`
	Language     string                 `json:"language,omitempty"`
	Region       string                 `json:"region,omitempty"`
	Version      string                 `json:"version,omitempty"`
	YandexUID    string                 `json:"yandexuid,omitempty"`
	Env          string                 `json:"env,omitempty"`
	Useragent    string                 `json:"useragent,omitempty"`
	Timestamp    int64                  `json:"timestamp"`
	URL          string                 `json:"url,omitempty"`
	Additional   map[string]interface{} `json:"additional,omitempty"`
	Page         string                 `json:"page,omitempty"`
	Fingerprint  string                 `json:"fingerprint,omitempty"`
	Line         int                    `json:"line,omitempty"`
	Col          int                    `json:"col,omitempty"`
}
