package errorbooster

import (
	"fmt"
	"strings"
)

// Write like [YATRAVEL][APP][BACKEND]
func prefixFromStringArray(data []string) string {
	result := ""
	for _, item := range data {
		result += fmt.Sprintf("[%s]", strings.ToUpper(item))
	}
	return result
}

func mergeDicts(dicts ...map[string]interface{}) map[string]interface{} {
	result := make(map[string]interface{})
	for _, dict := range dicts {
		for k, v := range dict {
			result[k] = v
		}
	}
	return result
}
