package errutil

import (
	"fmt"

	"a.yandex-team.ru/library/go/core/xerrors"
)

/* Wrap is useful if you want to manually gather stack traces with some custom additional info.
 Use it in a defer statement at the beginning of your function like this

	func SomeFunction(a,b int) (err error){
		defer Wrap(&err, "SomeFunction(%d, %d)", a, b)
		...
		if err!=nil{
			return err
		}
	}

*/
func Wrap(errp *error, format string, args ...interface{}) {
	if errp != nil && *errp != nil {
		s := fmt.Sprintf(format, args...)
		*errp = xerrors.SkipErrorf(1, "%s: %w", s, *errp)
	}
}
