package funcnames

import "fmt"

type Caller string

func (c Caller) String() string {
	return string(c)
}

func (c Caller) WrapError(err error) error {
	if err == nil {
		return nil
	}
	return fmt.Errorf("%s: %w", c, err)
}

func (c Caller) Panic(cause string) {
	panic(fmt.Sprintf("%s: %s", c, cause))
}
