package geobase

type Config struct {
	Path               string `config:"GEOBASE_PATH"`
	Mode               Mode   `config:"GEOBASE_MODE"`
	DevelopmentAPIHost string `yaml:"development_api_host"`
}

type Mode string

const (
	ModeBin  Mode = "bin"
	ModeHTTP Mode = "http"
	ModeStub Mode = "stub"
)

var DefaultConfig = Config{
	Path:               "/var/lib/resources/geodata/geodata6.bin",
	Mode:               ModeBin,
	DevelopmentAPIHost: "http://geobase.qloud.yandex.ru/v1",
}
