package consts

import "time"

const (
	MskLocationName = "Europe/Moscow"

	Day = 24 * time.Hour
)

var (
	MskLocation = mustLoadLocation(MskLocationName)
)

func mustLoadLocation(name string) *time.Location {
	if loc, err := time.LoadLocation(name); err != nil {
		panic("got error during parsing location: " + err.Error())
	} else {
		return loc
	}
}
