package http

import (
	"time"

	"github.com/cenkalti/backoff/v4"
)

type Option func(client *Client)

const DefaultTimeout = 10 * time.Second

func withDefaultBackOffPolicy(client *Client) {
	defaultBackOff := backoff.ExponentialBackOff{
		InitialInterval:     100 * time.Millisecond,
		RandomizationFactor: backoff.DefaultRandomizationFactor,
		Multiplier:          backoff.DefaultMultiplier,
		MaxInterval:         300 * time.Millisecond,
		MaxElapsedTime:      DefaultTimeout,
		Clock:               backoff.SystemClock,
		Stop:                backoff.Stop,
	}
	client.backOffPolicyGetter = func() backoff.BackOff {
		b := defaultBackOff
		return &b
	}
}

func withDefaultRequestTimeout(client *Client) {
	client.requestTimeout = DefaultTimeout
}

func WithBackOffPolicy(backOffPolicyGetter func() backoff.BackOff) Option {
	return func(client *Client) {
		client.backOffPolicyGetter = backOffPolicyGetter
	}
}

func WithRequestTimeout(timeout time.Duration) Option {
	return func(client *Client) {
		client.requestTimeout = timeout
	}
}
