package geobase

import (
	"time"

	"a.yandex-team.ru/library/go/yandex/geobase"
)

type Geobase interface {
	Destroy()
	GetRegionByIP(ip string) (*geobase.Region, error)
	GetCountryID(id int, crimea geobase.CrimeaStatus) (int, error)

	GetLinguistics(geoID int, lang string) (*geobase.Linguistics, error)
	GetLocationByID(geoID int) (*time.Location, error)
	GetRegion(geoID int) (*geobase.Region, error)
	RoundToRegion(geoID int, regionType geobase.RegionType) (*geobase.Region, error)
	GetRegionByLocation(latitude float64, longitude float64) (*geobase.Region, error)
}
