package geobase

import (
	"time"

	"a.yandex-team.ru/library/go/yandex/geobase"
	"a.yandex-team.ru/travel/library/go/geobase/consts"
)

// StubGeobase fallback to default logic if geobase is disabled
type StubGeobase struct{}

func (g StubGeobase) GetRegionByLocation(latitude float64, longitude float64) (*geobase.Region, error) {
	return &geobase.Region{ID: consts.MoscowGeoID}, nil
}

func (g StubGeobase) RoundToRegion(geoID int, regionType geobase.RegionType) (*geobase.Region, error) {
	return &geobase.Region{Type: regionType, ID: geobase.ID(geoID * 10)}, nil
}

func (g StubGeobase) GetLinguistics(geoID int, lang string) (*geobase.Linguistics, error) {
	return &geobase.Linguistics{}, nil
}

func (g StubGeobase) GetLocationByID(_ int) (*time.Location, error) {
	return consts.MskLocation, nil
}

func (g StubGeobase) GetRegion(_ int) (*geobase.Region, error) {
	return &geobase.Region{ID: consts.MoscowGeoID}, nil
}

func (g StubGeobase) GetRegionByIP(_ string) (*geobase.Region, error) {
	return &geobase.Region{ID: consts.MoscowGeoID}, nil
}

func (g StubGeobase) GetCountryID(_ int, _ geobase.CrimeaStatus) (int, error) {
	return consts.RussiaGeoID, nil
}

func (g StubGeobase) Destroy() {}
