package geotools

import "math"

const rEarth = 6378100.0

// GeoDistance returns the distance (in meters) between two points on Earth
// https://en.wikipedia.org/wiki/Haversine_formula
func GeoDistance(lat1, lon1, lat2, lon2 float64) float64 {

	// convert to radians
	lat1 = degreesToRadians(lat1)
	lat2 = degreesToRadians(lat2)
	lon1 = degreesToRadians(lon1)
	lon2 = degreesToRadians(lon2)

	h := haversin(lat2-lat1) + math.Cos(lat1)*math.Cos(lat2)*haversin(lon2-lon1)
	return 2 * rEarth * math.Asin(math.Sqrt(h))
}

func degreesToRadians(d float64) float64 {
	return d * math.Pi / 180.0
}

func haversin(theta float64) float64 {
	return math.Pow(math.Sin(theta/2), 2)
}
