package grpcgateway

import (
	"a.yandex-team.ru/library/go/core/resource"
	"encoding/json"
)

func (g *Gateway) loadSwaggerSchema(s *Service) (map[string]interface{}, error) {
	res := resource.MustGet(s.getJSONName())
	var schema map[string]interface{}
	if err := json.Unmarshal(res, &schema); err != nil {
		return nil, err
	}
	return schema, nil
}

func combineMaps(left map[string]interface{}, right map[string]interface{}) map[string]interface{} {
	if left == nil {
		return right
	}
	result := make(map[string]interface{})
	for key, value := range left {
		result[key] = value
	}
	for key, value := range right {
		existing, exists := left[key]
		if exists {
			result[key] = combinedNested(existing, value)
		} else {
			result[key] = value
		}
	}
	return result
}

func combineSlices(left []interface{}, right []interface{}) []interface{} {
	return append(left, right...)
}

func combinedNested(left interface{}, right interface{}) interface{} {
	switch {
	case isMap(left) && isMap(right):
		return combineMaps(left.(map[string]interface{}), right.(map[string]interface{}))
	case isSlice(left) && isSlice(right):
		return combineSlices(left.([]interface{}), right.([]interface{}))
	default:
		return left
	}
}

func isMap(o interface{}) bool {
	_, f := o.(map[string]interface{})
	return f
}

func isSlice(o interface{}) bool {
	_, f := o.([]interface{})
	return f
}

func addHeadersToSchema(schema map[string]interface{}, extraHeaders []HeaderSpec) (map[string]interface{}, error) {
	pathsObj, found := schema["paths"]
	if !found {
		return schema, nil
	}
	paths := pathsObj.(map[string]interface{})
	for _, apiPathObj := range paths {
		apiPath := apiPathObj.(map[string]interface{})
		for _, verbObj := range apiPath {
			verb := verbObj.(map[string]interface{})
			paramsObj, exists := verb["parameters"]
			var params []interface{}
			if exists {
				params = paramsObj.([]interface{})
			}
			for _, header := range extraHeaders {
				h := map[string]interface{}{
					"name":     header.Name,
					"in":       "header",
					"required": false,
				}
				if header.Description != "" {
					h["description"] = header.Description
				}
				if header.Default != "" {
					h["default"] = header.Default
				}
				if len(header.Enum) > 0 {
					h["enum"] = header.Enum
				}
				params = append(params, h)
			}
			if len(params) > 0 {
				verb["parameters"] = params
			}
		}
	}
	return schema, nil
}
