package balancerconfig

import (
	"fmt"

	hcbalancer "a.yandex-team.ru/travel/library/go/grpcutil/client/healthcheck_balancer"
)

func RoundRobin() string {
	return `{"loadBalancingPolicy":"round_robin"}`
}

func RoundRobinWithHealthCheck() string {
	return fmt.Sprintf(`{"loadBalancingPolicy":"%s"}`, hcbalancer.BalancerName)
}

func RoundRobinWithCustomHealthCheck(healthCheckServiceName string) string {
	return fmt.Sprintf(
		`{"loadBalancingPolicy":"%s", "healthCheckConfig": {"serviceName": "%s"}}`,
		hcbalancer.BalancerName,
		healthCheckServiceName,
	)
}
