package healthcheckbalancer

import (
	"sync"
	"time"

	"google.golang.org/grpc/balancer"

	"a.yandex-team.ru/library/go/core/log"
)

type hostListManager interface {
	updateHosts(hosts []string)
	isHealthy(host string) bool
	getLatency(host string) time.Duration
}

type namedSubConn struct {
	subConn balancer.SubConn
	host    string
}

type roundRobinPicker struct {
	subConns        []namedSubConn
	hostListManager hostListManager

	mu     sync.Mutex
	next   int
	logger log.Logger
}

func (p *roundRobinPicker) Pick(info balancer.PickInfo) (balancer.PickResult, error) {
	p.mu.Lock()
	defer p.mu.Unlock()

	for i := 0; i < len(p.subConns); i++ {
		p.next = (p.next + 1) % len(p.subConns)
		host := p.subConns[p.next].host
		if p.hostListManager.isHealthy(host) {
			p.logger.Debug("Picked host", log.String("host", host))
			return balancer.PickResult{SubConn: p.subConns[p.next].subConn}, nil
		}
	}
	return balancer.PickResult{}, balancer.ErrNoSubConnAvailable
}
