package ypresolver

import (
	"fmt"

	"a.yandex-team.ru/library/go/core/xerrors"
)

type ServiceDiscoveryNotAvailableError struct {
	err error
}

func (e ServiceDiscoveryNotAvailableError) Error() string {
	return xerrors.Errorf("unable to connect to the SD host: %w", e.err).Error()
}

type YPResolverNotAvailableError struct {
	err error
}

func (e YPResolverNotAvailableError) Error() string {
	return xerrors.Errorf("unable to create YP resolver: %w", e.err).Error()
}

type UnknownServiceNameError struct {
	err         error
	serviceName string
}

func (e UnknownServiceNameError) Error() string {
	return xerrors.Errorf("unable to resolve service %s via YP: %w", e.serviceName, e.err).Error()
}

type ServiceHasNoHostsError struct {
	serviceName string
}

func (e ServiceHasNoHostsError) Error() string {
	return fmt.Sprintf("service %s does not have any hosts listed in YP service discovery", e.serviceName)
}
