package client

import "fmt"

type RetryableError struct {
	err error
}

func NewRetryableError(err error) *RetryableError {
	return &RetryableError{err: err}
}

func (e *RetryableError) Error() string {
	return fmt.Errorf("request error [retryable]: %w", e.err).Error()
}

func (e *RetryableError) Unwrap() error {
	return e.err
}

type NotRetryableError struct {
	msg string
	err error
}

func NewNotRetryableError(msg string) *NotRetryableError {
	return &NotRetryableError{msg: msg}
}

func NewNotRetryableErrorWrap(err error) *NotRetryableError {
	return &NotRetryableError{err: err}
}

func (e *NotRetryableError) Error() string {
	if e.err != nil {
		return fmt.Errorf("request error [not retryable]: %w", e.err).Error()
	}
	return fmt.Sprintf("request error [not retryable]: %s ", e.msg)
}

func (e *NotRetryableError) Unwrap() error {
	return e.err
}

type BadResponseCodeError struct {
	Code int
}

func NewBadResponseCodeError(code int) *BadResponseCodeError {
	return &BadResponseCodeError{Code: code}
}

func (e *BadResponseCodeError) Error() string {
	return fmt.Sprintf("bad response code=%v", e.Code)
}
