package httputil

import (
	"encoding/json"
	"fmt"
)

const (
	UaasExperimentsHeader = "X-Ya-Uaas-Experiments"
)

type UaasExperiments struct {
	TrainsBanditType string `json:"TRAINS_bandit_type"`
}

func ParseExperiments(uaasStr string) (UaasExperiments, error) {
	funcName := "ParseExperiments"
	result := UaasExperiments{}
	if uaasStr != "" {
		err := json.Unmarshal([]byte(uaasStr), &result)
		if err != nil {
			return result, fmt.Errorf("%s: error json parse: %w", funcName, err)
		}
	}
	return result, nil
}
