package logging

import "go.uber.org/zap/zapcore"

const (
	KeyUserAgent    = "userAgent"
	KeyIPHeader     = "ipHeader"
	KeyRequestID    = "requestId"
	KeyError        = "error"
	KeyHost         = "host"
	KeyGRPCService  = "grpc.service"
	KeyGRPCMethod   = "grpc.method"
	KeyGRPCCode     = "grpc.code"
	KeyGRPCDuration = "grpc.duration"
)

func findErrorInZapFields(fields []zapcore.Field) error {
	var err error = nil
	for _, field := range fields {
		if field.Type == zapcore.ErrorType {
			var ok bool
			err, ok = field.Interface.(error)
			if ok && field.Key == KeyError {
				break
			}
		}
	}
	return err
}
