package metrics

import (
	"fmt"
	"net/http"
	"time"

	"a.yandex-team.ru/library/go/core/metrics/solomon"
	"a.yandex-team.ru/library/go/yandex/solomon/reporters/puller/httppuller"
)

type MetricsHandler struct {
	name    string
	handler func(http.ResponseWriter, *http.Request)
}

func (h *MetricsHandler) Handle(writer http.ResponseWriter, request *http.Request) {
	h.handler(writer, request)
}

func (h *MetricsHandler) GetRoute() string {
	return fmt.Sprintf("/metrics/%s/", h.name)
}

func NewMetricsHandler(name string, registry *solomon.Registry) *MetricsHandler {
	metricsHandler := httppuller.NewHandler(registry)
	return &MetricsHandler{handler: metricsHandler.ServeHTTP, name: name}
}

func NewPerfMetricsHandler(metricsRegistryPrefix string, refreshInterval time.Duration) *MetricsHandler {
	perfMetricsRegistry := solomon.NewRegistry(solomon.NewRegistryOpts())
	perfMetrics := NewPerfMetrics(perfMetricsRegistry.WithPrefix(metricsRegistryPrefix))
	go func() {
		for range time.Tick(refreshInterval) {
			perfMetrics.UpdateCurrentState()
		}
	}()
	return NewMetricsHandler("perf", perfMetricsRegistry)
}
