package metrics

import (
	"a.yandex-team.ru/library/go/core/metrics"
	"net/http"
	"time"
)

type MetricsMiddleware struct {
	timer metrics.Timer
}

func (m *MetricsMiddleware) Handle(next http.Handler) http.Handler {
	return http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		start := time.Now()
		next.ServeHTTP(w, r)
		m.timer.RecordDuration(time.Since(start))
	})
}

/*
Deprecated, keeping it only for avia/wizard
*/
func NewMetricsMiddleware(timer metrics.Timer) *MetricsMiddleware {
	return &MetricsMiddleware{timer: timer}
}
