package metrics

import (
	"os"

	"a.yandex-team.ru/library/go/core/metrics"
	"a.yandex-team.ru/library/go/core/metrics/solomon"
)

func NewAppMetricsRegistryWithPrefix(prefix string) *solomon.Registry {
	metricsRegistry := solomon.NewRegistry(solomon.NewRegistryOpts().SetPrefix(prefix))
	metricsRegistry.Gauge("alive").Set(1)
	return metricsRegistry
}

func NewRegistryWithQloudTags() metrics.Registry {
	registryOpts := solomon.NewRegistryOpts()
	solomonRegistry := solomon.NewRegistry(registryOpts)
	registry := solomonRegistry.WithTags(extractQloudTags())
	registry.Gauge("alive").Set(1)
	return registry
}

func extractQloudTags() map[string]string {
	tagToEnv := map[string]string{
		"host":        "QLOUD_DISCOVERY_INSTANCE",
		"application": "QLOUD_APPLICATION", // TODO: useless - duplicate for solomon-service
		"environment": "QLOUD_ENVIRONMENT", // TODO: useless - duplicate for solomon-cluster
		"component":   "QLOUD_COMPONENT",
	}
	result := make(map[string]string, 4)
	for _, tag := range []string{"host", "application", "environment", "component"} {
		result[tag] = os.Getenv(tagToEnv[tag])
	}
	return result
}

func NewRegistryWithDeployTagsAndExplicitHost() metrics.Registry {
	registryOpts := solomon.NewRegistryOpts()
	solomonRegistry := solomon.NewRegistry(registryOpts)
	registry := solomonRegistry.WithTags(extractDeployTagsWithExplicitHost())
	registry.Gauge("alive").Set(1)
	return registry
}

func extractDeployTagsWithExplicitHost() map[string]string {
	tagToEnv := map[string]string{
		"stage":      "DEPLOY_STAGE_ID",
		"datacenter": "DEPLOY_NODE_DC",
		"pod":        "DEPLOY_POD_PERSISTENT_FQDN",
		"host":       "DEPLOY_NODE_FQDN",
		"unit":       "DEPLOY_UNIT_ID",
		"box":        "DEPLOY_BOX_ID",
	}
	result := make(map[string]string, len(tagToEnv))
	for tag := range tagToEnv {
		result[tag] = os.Getenv(tagToEnv[tag])
	}
	return result
}

func NewRegistryWithDeployTags() metrics.Registry {
	registryOpts := solomon.NewRegistryOpts()
	solomonRegistry := solomon.NewRegistry(registryOpts)
	registry := solomonRegistry.WithTags(extractDeployTags())
	registry.Gauge("alive").Set(1)
	return registry
}

func extractDeployTags() map[string]string {
	tagToEnv := map[string]string{
		"stage":      "DEPLOY_STAGE_ID",
		"datacenter": "DEPLOY_NODE_DC",
		"unit":       "DEPLOY_UNIT_ID",
		"box":        "DEPLOY_BOX_ID",
	}
	result := make(map[string]string, len(tagToEnv))
	for tag := range tagToEnv {
		result[tag] = os.Getenv(tagToEnv[tag])
	}
	return result
}
