package renderer

import (
	"fmt"
)

type InvalidRequestError struct {
	err error
}

func (e InvalidRequestError) Error() string {
	return fmt.Errorf("invalid request: %w", e.err).Error()
}

type RequestRendererError struct {
	err error
}

func (e RequestRendererError) Error() string {
	return fmt.Errorf("error while requesting renderer: %w", e.err).Error()
}

type InvalidResponseError struct {
	err error
}

func (e InvalidResponseError) Error() string {
	return fmt.Errorf("invalid response: %w", e.err).Error()
}
