package renderer

import (
	"time"

	"github.com/cenkalti/backoff/v4"
)

type Option func(*HTTPClient)

func withDefaultBackOffPolicy(client *HTTPClient) {
	defaultBackOff := backoff.ExponentialBackOff{
		InitialInterval:     backoff.DefaultInitialInterval,
		RandomizationFactor: backoff.DefaultRandomizationFactor,
		Multiplier:          backoff.DefaultMultiplier,
		MaxInterval:         100 * time.Millisecond,
		MaxElapsedTime:      1 * time.Second,
		Clock:               backoff.SystemClock,
		Stop:                backoff.Stop,
	}
	client.backOffPolicyGetter = func() backoff.BackOff {
		b := defaultBackOff
		return &b
	}
}

func withDefaultRequestTimeout(client *HTTPClient) {
	client.requestTimeout = 2 * time.Second
}

func WithBackOffPolicy(backOffPolicyGetter func() backoff.BackOff) Option {
	return func(client *HTTPClient) {
		client.backOffPolicyGetter = backOffPolicyGetter
	}
}

func WithRequestTimeout(timeout time.Duration) Option {
	return func(client *HTTPClient) {
		client.requestTimeout = timeout
	}
}
