package sender

import (
	"fmt"
	"strings"
)

type InvalidRequestError struct {
	err error
}

func (e InvalidRequestError) Error() string {
	return fmt.Errorf("invalid request: %w", e.err).Error()
}

type RequestSenderError struct {
	err error
}

func (e RequestSenderError) Error() string {
	return fmt.Errorf("error while requesting Sender: %w", e.err).Error()
}

type ResponseParsingError struct {
	err error
}

func (e ResponseParsingError) Error() string {
	return fmt.Errorf("error while parsing Sender's response: %w", e.err).Error()
}

type InvalidEmailError struct {
	error
	reasons []string
}

func NewInvalidEmailError(reasons []string) *InvalidEmailError {
	return &InvalidEmailError{reasons: reasons}
}

func (e InvalidEmailError) Error() string {
	return strings.Join(e.reasons, "; ")
}
