package sender

import "context"

type Client interface {
	SendTransactional(ctx context.Context, sendRequest TransactionalRequest) ([]byte, error)
	Unsubscribe(ctx context.Context, request UnsubscribeListRequest) error
	Subscribe(ctx context.Context, request UnsubscribeListRequest) error
}

type responseRoot struct {
	Result responseResult `json:"result"`
}

type responseResult struct {
	Status string      `json:"status"`
	Error  SenderError `json:"error"`
}

type SenderError struct {
	Email []string `json:"email"`
}

type TransactionalRequest struct {
	CampaignSlug string
	ToEmail      string
	SendAsync    bool
	Args         map[string]string
	Headers      map[string]string
}

type UnsubscribeListRequest struct {
	Email               string
	UnsubscribeListSlug string
}
