==Abstract

Начиная новый сервис, обычно необходимо ответить на ряд типовых вопросов:
  - организация кода
  - как деплоить
  - как собирать метрики
  - как работать с конфигурацией
  - как запускать тесты
  - как писать логи
  - работа с секретницей
  - работа со справочниками
  - трассировка
  
Задача service template ответить на эти вопросы. В общем случае, ожидается что service_template можно просто
скопировать к себе и переименовать.

==First things first
Как запустить?
```sh
ya make
./cmd/api/api
``` 

**Проверка**
Grpc
```sh
grpcurl -emit-defaults -plaintext -d '{"echo_mode": 3, "query": "Hello"}' localhost:9001 NExampleService.NServiceTemplate.EchoServiceV1.Echo
```

Http
```sh
curl "http://localhost:9000/echo?echo_mode=1&query=Hello"
```

Healthcheck
```sh
grpcurl -emit-defaults -plaintext -d '{"service": "service_template"}' localhost:9001 grpc.health.v1.Health.Check
```

==Структура и описание

По мотивам:  https://github.com/golang-standards/project-layout

**Иерархия пакетов**
 
   * cmd - точки запуска для апи и для консольной утилиты
   * docker - содержимое, необходимое для сборки docker образа
   * internal - тут вся логика приложения
       * app - общее состояние/бутстрап приложения
       * echo - пакет, реализующий простую бизнес логику - вернуть то же, что и запросили.
         - handler - тут обработчики для http/grpc АПИ
         - service.go - тут лежит функция, реализующая бизнес логику
       * healthswitch - пакет, реализующий логику переключения health статуса
         - handler - тут обработчики для http/grpc АПИ
         - switch.go - тут лежит бизнес логика
   * api - спецификация АПИ приложения, сюда кладем proto файлы и swagger спецификации

Можно заметить, что в internal код разделен на пакеты, где каждый пакет отвечает за какую то ограниченную бизнес область. В приведенном примере - бизнес области очень просты, они описываются одной функцией. В реальности - один пакет может отвечать, например, за "поиск тарифов", "авторизацию", "отправку писем". Важно следить за тем, чтобы эти пакеты не зависели друг от друга. То есть пакет internal/echo не должен зависеть от internal/healthswitch и т.д. Если у них есть общий код - его следует класть в internal/pkg/, если у них есть общие зависимости - следует включить их в точке инициализации приложения.
Рассмотрим возможную структуру пакетов, реализующих бизнес логику. Допустим у нас есть пакет internal/foo, допустим у него есть свое состояние в БД, есть какая то зависимость от внешнего сервиса и какая то бизнес логика для работы со справочниками. Тогда структура проекта может быть примерно такой: 
  
  * internal
    * foo
        - models - тут модели для работы с БД
        - dicts - работа со справочниками
        - qux - пакет для работы с внешним сервисом
        - service - сюда можно положить реализацию бизнес логики нашего foo
        - handler - а сюда обработчики для grpc / http
    * bar
        - handler
        - service
    * pkg
        - utils
        - dict
        - logging

Сервис принимает запросы напрямую, без nginx.
Метрики собираются без использования solomon-agent'а и nginx.

==FAQ

**А если у меня микросервис, который отвечает за один домен / функцию - мне все равно надо пилить такую разухабистую иерархию пакетов?**

Думаю подойдет упрощенная:

  *  internal
    - models
    - dicts
    - service
    - handler

**Я слышал - у нас есть справочники, а как ими пользоваться?**

Смотри [примеры](https://a.yandex-team.ru/arc/trunk/arcadia/travel/library/go/dicts/) 

**А что еще полезного есть?**

Смотри [библиотеку Путешествий](https://a.yandex-team.ru/arc/trunk/arcadia/travel/library/go/)
И [библиотеку Яндекса](https://a.yandex-team.ru/arc/trunk/arcadia/library/go/)
Именно в таком порядке.

**А как настроить метрики?**

Метрики наше приложение уже собирает, и выпячивает на "http:[::]:9947/metrics/".
Теперь нужно настроить их сбор в админке solomon (завести сервис и кластера) - см [документацию](https://solomon.yandex-team.ru/docs/howtostart/quickstart)
И далее, при помощи [Solomon Tool](https://docs.yandex-team.ru/travel/ops/tools/solomon_tool) завести дашборды и алерты.
Почитать про [общие правила и рекомендации относительно метрик](https://docs.yandex-team.ru/travel/dev/metrics) 
А еще есть отличная [дока от Авиа](https://wiki.yandex-team.ru/avia/dev/solomon/#ispolzovaniesolomon-tool) 

==TODO

  * можно превратить его в настоящий шаблон, из которого можно генерировать каркас приложения через консольную утилиту
  * добавить утилиту / скрипт для создания и конфигурации приложения в deploy
  * добавить конфиги алертов и инструкцию по их применению
  * добавить пример apphost приложения
