package app

import (
	"a.yandex-team.ru/travel/library/go/grpcgateway"
	grpcserver "a.yandex-team.ru/travel/library/go/grpcutil/server"
	httpserver "a.yandex-team.ru/travel/library/go/httputil/server"
	"a.yandex-team.ru/travel/library/go/logging"
	metricsserver "a.yandex-team.ru/travel/library/go/metrics/server"
	"time"
)

type TvmConfig struct {
	Enabled   bool     `config:"tvm-enabled"`
	WhiteList []uint32 `config:"tvm-white-list"`
}

type Config struct {
	EnvType     string `config:"yenv-type,required"`
	HealthCheck HealthCheckConfig
	HTTP        httpserver.HTTPConfig
	Grpc        grpcserver.GrpcConfig
	GrpcGateway grpcgateway.Config
	Metrics     metricsserver.MetricsConfig
	Logging     logging.Config
	Tvm         TvmConfig
}

type HealthCheckConfig struct {
	UpdateInterval time.Duration `config:"health-check-update-interval"`
}

var DefaultHealthCheckConfig = HealthCheckConfig{
	UpdateInterval: 1 * time.Second,
}

var DefaultTvmConfig = TvmConfig{
	Enabled:   false,
	WhiteList: nil,
}

var Cfg = Config{
	EnvType:     "development",
	HealthCheck: DefaultHealthCheckConfig,
	HTTP:        httpserver.DefaultHTTPConfig,
	Grpc:        grpcserver.DefaultGrpcConfig,
	GrpcGateway: grpcgateway.DefaultConfig,
	Metrics:     metricsserver.DefaultMetricsConfig,
	Logging:     logging.DefaultConfig,
	Tvm:         DefaultTvmConfig,
}
