package handler

import (
	"a.yandex-team.ru/library/go/core/log"
	pb "a.yandex-team.ru/travel/library/go/service_template/api"
	"a.yandex-team.ru/travel/library/go/service_template/internal/echo"
	"context"
	"github.com/opentracing/opentracing-go"
	"google.golang.org/grpc"
)

type GRPCEchoHandler struct {
	logger log.Logger
}

func NewGRPCEchosHandler(l log.Logger) *GRPCEchoHandler {
	return &GRPCEchoHandler{logger: l}
}

func (h *GRPCEchoHandler) Echo(ctx context.Context, request *pb.EchoRequest) (*pb.EchoResponse, error) {
	span, _ := opentracing.StartSpanFromContext(ctx, "internal.echo.handler.GRPCEchoHandler: Echo")
	defer span.Finish()

	result, err := echo.ProcessQuery(echo.Mode(request.EchoMode), request.Query)
	if err != nil {
		return nil, err
	}
	return &pb.EchoResponse{Response: result}, nil
}

func (h *GRPCEchoHandler) GetServiceRegisterer() func(*grpc.Server) {
	return func(server *grpc.Server) {
		pb.RegisterEchoServiceV1Server(server, h)
	}
}
