package echo

import (
	"errors"
	"time"
)

type Mode int

const (
	Echo Mode = iota
	Error
	TimeOut
)

func ProcessQuery(mode Mode, query string) (string, error) {
	switch mode {
	case Error:
		return "", errors.New("error happend")
	case TimeOut:
		time.Sleep(1 * time.Minute)
	default:
		break
	}
	return query, nil
}
