package messagecollector

import (
	"context"
)

type MessageDispatcher interface {
	Dispatch(message []byte) error
}

type Limiter interface {
	BeforeDispatch()
	AfterDispatch()
}

type Source interface {
	Name() string
	Ready() bool
	Run(context.Context, MessageDispatcher)
}
