package messagecollector

import "github.com/cenkalti/backoff/v4"

type route struct {
	enabled            bool
	source             Source
	baseDispatcher     MessageDispatcher
	limiters           []Limiter
	backoffPolicy      backoff.BackOff
	dispatcherWrappers []DispatcherWrapper
}

func newRoute(enabled bool, source Source, dispatcher MessageDispatcher, options ...RouteOption) *route {
	r := &route{
		enabled:        enabled,
		source:         source,
		baseDispatcher: dispatcher,
	}
	for _, option := range options {
		option(r)
	}
	return r
}

type RouteOption func(*route)

func WithLimiter(limiter Limiter) RouteOption {
	return func(route *route) {
		route.limiters = append(route.limiters, limiter)
	}
}

func WithRetrying(backoffPolicy backoff.BackOff) RouteOption {
	return func(route *route) {
		route.backoffPolicy = backoffPolicy
	}
}

func WithDispatcherWrapper(dispatcherWrapper DispatcherWrapper) RouteOption {
	return func(route *route) {
		route.dispatcherWrappers = append(route.dispatcherWrappers, dispatcherWrapper)
	}
}
