package messagecollector

import (
	"context"
)

type Consumer interface {
	Name() string
	Ready() bool
	Run(ctx context.Context, dispatcher func([]byte) error)
}

type LogbrockerSource struct {
	consumer Consumer
}

func NewLogbrockerSource(consumer Consumer) *LogbrockerSource {
	return &LogbrockerSource{
		consumer: consumer,
	}
}

func (s *LogbrockerSource) Name() string {
	return s.consumer.Name()
}

func (s *LogbrockerSource) Ready() bool {
	return s.consumer.Ready()
}

func (s *LogbrockerSource) Run(ctx context.Context, dispatcher MessageDispatcher) {
	s.consumer.Run(ctx, dispatcher.Dispatch)
}
