package sandbox

import (
	"fmt"
	"net/url"
	"strconv"
)

type Query interface {
	validate() error
	ToURLValues() url.Values
}

type ResourceQuery struct {
	Limit  int
	Offset int
	Order  []string
	Type   string
}

func (query *ResourceQuery) validate() error {
	if query.Limit == 0 {
		return fmt.Errorf("parameter 'limit' is required")
	}
	return nil
}

func (query *ResourceQuery) ToURLValues() url.Values {
	values := make(url.Values)
	values.Set("limit", strconv.Itoa(query.Limit))

	if query.Type != "" {
		values.Set("type", query.Type)
	}

	if query.Offset > 0 {
		values.Set("offset", strconv.Itoa(query.Offset))
	}

	if len(query.Order) > 0 {
		for _, value := range query.Order {
			values.Add("order", value)
		}
	}
	return values
}
