package tanker

import (
	"a.yandex-team.ru/travel/library/go/strutil"
)

type Project struct {
	KeysetInfos map[string]*KeysetInfo `json:"keysets"`
}

type KeysetInfo struct {
	Keys Keyset `json:"keys"`
}

type Keyset map[string]*KeysetEntry

type KeysetEntry struct {
	Info         *Info                   `json:"info"`
	Translations map[string]*Translation `json:"translations"`
}

type Info struct {
	Context  string `json:"context"`
	IsPlural bool   `json:"is_plural"`
}

type Translation struct {
	Form  string `json:"form"`
	Form1 string `json:"form1,omitempty"`
	Form2 string `json:"form2,omitempty"`
	Form3 string `json:"form3,omitempty"`
}

func (k Keyset) GetSingular(key, language string) string {
	return k[key].Translations[language].Form
}

func (k Keyset) GetPlural(key, language string, count int) string {
	rem10 := count % 10
	rem100 := count % 100
	if rem100 >= 10 && rem100 <= 20 {
		return strutil.Coalesce(
			k[key].Translations[language].Form2,
			k[key].Translations[language].Form1,
			k[key].Translations[language].Form,
		)
	}
	// 1 час, 21 час
	if rem10 == 1 {
		return k[key].Translations[language].Form
	}
	// 2 часа, 3 часа, 4 часа
	if rem10 == 2 || rem10 == 3 || rem10 == 4 {
		return strutil.Coalesce(k[key].Translations[language].Form1, k[key].Translations[language].Form)
	}
	return strutil.Coalesce(
		k[key].Translations[language].Form2,
		k[key].Translations[language].Form1,
		k[key].Translations[language].Form,
	)
}
