package next

import (
	"context"
	"fmt"
	"time"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/travel/library/go/httputil/client"
	tankerpb "a.yandex-team.ru/travel/proto/tanker"
)

type TankerHTTPClient struct {
	client *client.HTTPClient
	logger log.Logger
}

func NewTankerHTTPClient(baseURL string, logger log.Logger, oAuthToken string) (*TankerHTTPClient, error) {
	tc, err := client.NewHTTPClient(baseURL,
		time.Second*2,
		0,
		0,
		client.ContentTypeJSON,
		logger,
		client.OAuthAuthProvider{
			OAuthToken: oAuthToken,
		},
	)
	if err != nil {
		return nil, err
	}
	return &TankerHTTPClient{
		client: tc,
		logger: logger,
	}, nil
}

func (t *TankerHTTPClient) GetKeySetData(ctx context.Context, project string, branch string, keySet string) (
	*tankerpb.KeySetExportResponse, error) {
	rsp := tankerpb.KeySetExportResponse{}
	path := fmt.Sprintf("api/v1/project/%s/branch/%s/keyset/%s/export", project, branch, keySet)
	err := t.client.Get(ctx, path, &exportRequest{}, &rsp)
	if err != nil {
		return nil, fmt.Errorf("tanker: error getting keySet data. path: %s. error: %w", path, err)
	}
	return &rsp, nil
}

type exportRequest struct{}
