package next

import "fmt"

type KeyNotFoundError struct {
	Key string
}

func NewKeyNotFoundError(key string) *KeyNotFoundError {
	return &KeyNotFoundError{Key: key}
}

func (e *KeyNotFoundError) Error() string {
	return fmt.Sprintf("tanker: no '%s' key in keyset", e.Key)
}

type NoTranslationError struct {
	Key      string
	Language string
}

func NewNoTranslationError(key string, language string) *NoTranslationError {
	return &NoTranslationError{Key: key, Language: language}
}

func (e *NoTranslationError) Error() string {
	return fmt.Sprintf("tanker: no translation for '%s' language, '%s' key in keyset", e.Language, e.Key)
}
