package tanker

import (
	"bytes"
	"text/template"
)

func TemplateToString(key string, translationForm string, placeholderValues map[string]interface{}) (string, error) {
	translationTemplate := template.New(key)
	translationTemplate, err := translationTemplate.Parse(translationForm)
	if err != nil {
		return "", err
	}

	buffer := bytes.Buffer{}
	err = translationTemplate.Execute(&buffer, placeholderValues)
	if err != nil {
		return "", err
	}
	return buffer.String(), nil
}
