package tracing

import (
	"io"

	"a.yandex-team.ru/library/go/core/log/zap"
	"github.com/opentracing/opentracing-go"
	"github.com/uber/jaeger-client-go"
	"github.com/uber/jaeger-client-go/config"
	jaegerZap "github.com/uber/jaeger-client-go/log/zap"
)

func InitializeDefaultTracer(serviceName string) io.Closer {
	tracer, closer, err := config.Configuration{
		ServiceName: serviceName,
		Sampler: &config.SamplerConfig{
			Type:  jaeger.SamplerTypeConst,
			Param: 1,
		},
	}.NewTracer()
	if err != nil {
		panic(err)
	}
	opentracing.SetGlobalTracer(tracer)
	return closer
}

func InitializeGlobalTracer(serviceName string, logger *zap.Logger) io.Closer {
	log := config.Logger(jaegerZap.NewLogger(logger.L))
	tracer, closer, err := config.Configuration{
		ServiceName: serviceName,
		Sampler: &config.SamplerConfig{
			Type:  jaeger.SamplerTypeConst,
			Param: 1,
		},
		Reporter: &config.ReporterConfig{
			LogSpans: true,
		},
	}.NewTracer(log)
	if err != nil {
		panic(err)
	}
	opentracing.SetGlobalTracer(tracer)
	return closer
}

func InitializeTracerWithSampling(serviceName string, sc *config.SamplerConfig) io.Closer {
	tracer, closer, err := config.Configuration{
		ServiceName: serviceName,
		Sampler:     sc,
	}.NewTracer()
	if err != nil {
		panic(err)
	}
	opentracing.SetGlobalTracer(tracer)
	return closer
}
