package tvm

import (
	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/core/log/nop"
	tvmutil "a.yandex-team.ru/library/go/httputil/middleware/tvm"
	yatvm "a.yandex-team.ru/library/go/yandex/tvm"
	"context"
	"google.golang.org/grpc"
	"google.golang.org/grpc/metadata"
)

type ClientOption func(*clientInterceptor)

type clientInterceptor struct {
	l   log.Logger
	tvm yatvm.Client
	dst yatvm.ClientID
}

func ClientInterceptor(tvmClient yatvm.Client, opts ...ClientOption) grpc.UnaryClientInterceptor {
	m := clientInterceptor{
		tvm: tvmClient,
		l:   &nop.Logger{},
	}
	for _, opt := range opts {
		opt(&m)
	}
	return func(ctx context.Context, method string, req, reply interface{}, cc *grpc.ClientConn, invoker grpc.UnaryInvoker, opts ...grpc.CallOption) error {
		if m.tvm != nil {
			ticket, err := m.tvm.GetServiceTicketForID(ctx, m.dst)
			if err != nil {
				m.l.Errorf("error get service ticket for dst=%v: %v", m.dst, err.Error())
			}
			ctx = metadata.AppendToOutgoingContext(ctx, tvmutil.XYaServiceTicket, ticket)
		}
		return invoker(ctx, method, req, reply, cc, opts...)
	}
}

func ClientWithLogger(l log.Logger) ClientOption {
	return func(m *clientInterceptor) {
		m.l = l
	}
}

func ClientWithDst(dst uint32) ClientOption {
	return func(m *clientInterceptor) {
		m.dst = yatvm.ClientID(dst)
	}
}
