package ru.yandex.travel.integration.balance;

import java.time.Duration;

import javax.validation.constraints.NotNull;

import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

import ru.yandex.travel.commons.http.apiclient.HttpApiWithTvmPropertiesBase;

@Data
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class BillingApiProperties extends HttpApiWithTvmPropertiesBase {
    @NotNull
    private Boolean enabled;

    @Builder
    public BillingApiProperties(String baseUrl, Duration httpReadTimeout, Duration httpRequestTimeout,
                                Boolean tvmEnabled, String tvmDestinationAlias, Boolean enabled) {
        super(baseUrl, httpReadTimeout, httpRequestTimeout, tvmEnabled, tvmDestinationAlias);
        this.enabled = enabled;
    }
}
