package ru.yandex.travel.integration.balance;

import java.time.LocalDateTime;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class BillingClientContract {
    @JsonProperty("ID")
    private Long id;
    @JsonProperty("EXTERNAL_ID")
    private String externalId;
    @JsonProperty("CONTRACT_TYPE")
    private Integer contractType;
    @JsonProperty("PERSON_ID")
    private Long personId;
    @JsonProperty("MANAGER_CODE")
    private Long managerCode;
    @JsonProperty("SERVICES")
    private List<Integer> services;
    @JsonProperty("CURRENCY")
    private String currency;
    @JsonProperty("PAYMENT_TYPE")
    private Integer paymentType;
    @JsonProperty("DT")
    private LocalDateTime dt;

    @JsonProperty("IS_ACTIVE")
    private boolean active;
    @JsonProperty("IS_SIGNED")
    private boolean signed;
    @JsonProperty("OFFER_ACCEPTED")
    private boolean offerAccepted;
    @JsonProperty("IS_FAXED")
    private boolean faxed;
    @JsonProperty("IS_CANCELLED")
    private boolean cancelled;
    @JsonProperty("IS_DEACTIVATED")
    private boolean deactivated;
    @JsonProperty("IS_SUSPENDED")
    private boolean suspended;
}
