package ru.yandex.travel.integration.balance.csv;

import java.time.LocalDateTime;

import org.apache.commons.csv.CSVRecord;

import ru.yandex.travel.integration.balance.model.csv.BankOrder;
import ru.yandex.travel.integration.balance.model.csv.BankOrderStatus;
import ru.yandex.travel.integration.balance.model.csv.OebsPaymentStatus;

public class BankOrderParser extends BaseResultCsvParser<BankOrder> {

    private static final String PAYMENT_BATCH_ID = "payment_batch_id";
    private static final String TRANTIME = "trantime";
    private static final String EVENTTIME = "eventtime";
    private static final String STATUS = "status";
    private static final String BANK_ORDER_ID = "bank_order_id";
    private static final String SUM = "sum";
    private static final String OEBS_STATUS = "oebs_status";
    private static final String DESCRIPTION = "description";

    private final long serviceId;

    public BankOrderParser(long serviceId) {
        super(null);
        this.serviceId = serviceId;
    }

    @Override
    protected BankOrder convert(CSVRecord record) {
        return BankOrder.builder()
                .paymentBatchId(record.get(PAYMENT_BATCH_ID))
                .trantime(CsvValueParser.parseLocalDateTime(record.get(TRANTIME)).orElseThrow())
                .eventtime(CsvValueParser.parseLocalDateTime(record.get(EVENTTIME)).map(LocalDateTime::toLocalDate).orElseThrow())
                .status(BankOrderStatus.valueOf(record.get(STATUS)))
                .bankOrderId(record.get(BANK_ORDER_ID))
                .sum(CsvValueParser.parseBigDecimal(record.get(SUM)).orElseThrow())
                .oebsPaymentStatus(OebsPaymentStatus.valueOf(record.get(OEBS_STATUS)))
                .serviceId(serviceId)
                .description(record.get(DESCRIPTION))
                .build();
    }
}
