package ru.yandex.travel.integration.balance.csv;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

import javax.annotation.Nullable;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVRecord;


@Slf4j
public abstract class BaseResultCsvParser<T> {

    private static final CSVFormat FORMAT = CSVFormat.DEFAULT
            .withDelimiter(';')
            .withIgnoreEmptyLines()
            .withFirstRecordAsHeader();

    private final CSVFormat format;

    public BaseResultCsvParser(@Nullable CSVFormat format) {
        if (Objects.isNull(format)) {
            this.format = FORMAT;
        } else {
            this.format = format;
        }
    }

    public Stream<T> readInputStream(InputStream s) throws IOException {
        final InputStreamReader reader = new InputStreamReader(s);
        return StreamSupport.stream(format.parse(reader).spliterator(), false).map(this::convert);
    }

    public List<T> parse(InputStream stream) throws IOException {
        return readInputStream(stream).collect(Collectors.toList());
    }

    protected abstract T convert(CSVRecord record);
}
