package ru.yandex.travel.integration.balance.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * <a href="https://wiki.yandex-team.ru/balance/xmlrpc/#balance.createclient">Format docs</a>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
@JsonInclude(JsonInclude.Include.NON_NULL)
public class BillingClient {
    @JsonProperty("CLIENT_ID")
    private Long clientId;

    @JsonProperty("CLIENT_TYPE_ID")
    private Integer clientTypeId;

    @JsonProperty("NAME")
    private String name;

    @JsonProperty("EMAIL")
    private String email;

    @JsonProperty("PHONE")
    private String phone;

    @JsonProperty("FAX")
    private String fax;

    @JsonProperty("URL")
    private String url;

    @JsonProperty("CITY")
    private String city;

    @JsonProperty("IS_AGENCY")
    private Boolean isAgency;

    @JsonProperty("AGENCY_ID")
    private Integer agencyId;

    @JsonProperty("REGION_ID")
    private Integer regionId;

    @JsonProperty("SUBREGION_ID")
    private Integer subRegionId;

    @JsonProperty("SERVICE_ID")
    private Integer serviceId;

    @JsonProperty("CURRENCY")
    private String currency;
}
