package ru.yandex.travel.integration.balance.model;

import java.time.LocalDate;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Builder;
import lombok.Data;

/**
 * The class is used for create/update requests only. Don't confuse it with
 * {@linkplain ru.yandex.travel.integration.balance.BillingClientContract BillingClientContract}.
 * <a href="https://wiki.yandex-team.ru/Balance/XmlRpc/#balance.createcommoncontract">Format docs</a>
 */
@Data
@Builder
@JsonInclude(JsonInclude.Include.NON_NULL)
public class BillingContract {
    @JsonProperty("client_id")
    private Long clientId;

    @JsonProperty("person_id")
    private Long personId;

    @JsonProperty("ctype")
    private BillingContractType contractType;

    @JsonProperty("currency")
    private String currency;

    @JsonProperty("external_id")
    private String externalId;

    @JsonProperty("firm_id")
    private Long firmId;

    @JsonProperty("services")
    private List<Integer> services;

    @JsonProperty("payment_type")
    private BillingPaymentType paymentType;

    @JsonProperty("payment_term")
    private Integer paymentTerm;

    @JsonProperty("manager_uid")
    private Long managerUid;

    @JsonProperty("manager_code")
    private Long managerCode;

    @JsonProperty("manager_bo_code")
    private Long managerBoCode;

    @JsonProperty("start_dt")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd")
    private LocalDate startDate;

    @JsonProperty("offer_confirmation_type")
    private BillingOfferConfirmationType offerConfirmationType;

    @JsonProperty("commission")
    private BillingCommissionType commission;
}
