package ru.yandex.travel.integration.balance.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * <a href="https://wiki.yandex-team.ru/balance/xmlrpc/#balance.createperson">Format docs</a>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
@JsonInclude(JsonInclude.Include.NON_NULL)
public class BillingUrPerson {
    public static final String PERSON_TYPE_UR = "ur";

    @JsonProperty("person_id")
    private Long personId;

    @JsonProperty("client_id")
    private Long clientId;

    @JsonProperty("name")
    private String name;

    @JsonProperty("longname")
    private String longName;

    @JsonProperty("inn")
    private String inn;

    @JsonProperty("kpp")
    private String kpp;

    @JsonProperty("phone")
    private String phone;

    @JsonProperty("email")
    private String email;

    @JsonProperty("postcode")
    private String postCode;

    @JsonProperty("postaddress")
    private String postAddress;

    @JsonProperty("legaladdress")
    private String legalAddress;

    @JsonProperty("bik")
    private String bik;

    @JsonProperty("account")
    private String account;

    @JsonProperty("live-signature")
    private String liveSignature;

    @JsonProperty("signer-person-name")
    private String signerPersonName;

    @JsonProperty("authority-doc-details")
    private String authorityDocDetails;

    @JsonProperty("type")
    public String getType() {
        return PERSON_TYPE_UR;
    }

    public void setType(String type) {
        Preconditions.checkArgument(PERSON_TYPE_UR.equals(type),
                "Only the 'ur' type is supported by this class; got %s", type);
    }
}
