package ru.yandex.travel.integration.balance.model.csv;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

import javax.annotation.Nonnull;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

/**
 * Платежное поручение.
 */
@Data
@AllArgsConstructor
@Builder
public class BankOrder {

    /**
     * Идентификатор сервиса.
     */
    private final long serviceId;

    /**
     * Идентификатор платежного поручения.
     */
    @Nonnull
    private final String paymentBatchId;

    /**
     * Время обновления статуса.
     */
    @Nonnull
    private final LocalDateTime trantime;

    /**
     * Дата платежа. От OEBS теоретически может придти со временем, но в этом случае кастуем к дате.
     */
    @Nonnull
    private final LocalDate eventtime;

    /**
     * Статус платежа.
     */
    @Nonnull
    private final BankOrderStatus status;

    /**
     * Номер платежного поручения.
     */
    @Nonnull
    private final String bankOrderId;

    /**
     * Итоговая сумма выплаты по ПП, в валюте договора.
     */
    private final BigDecimal sum;

    /**
     * Статус платежного поручения в ОЕБС.
     */
    @Nonnull
    private final OebsPaymentStatus oebsPaymentStatus;

    /**
     * Описание платежа
     */
    private final String description;
}
