package ru.yandex.travel.integration.balance.model.csv;

import java.math.BigDecimal;
import java.time.LocalDate;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import lombok.Builder;
import lombok.Data;
import lombok.RequiredArgsConstructor;

/**
 * Детализация платежного поручения.
 */
@Data
@RequiredArgsConstructor
@Builder
public class BankOrderDetail {
    // TODO: Add validation throw new IllegalArgumentException("Both trustPaymentId and trustRefundId are null");

    /**
     * Идентификатор платежного поручения.
     */
    @Nonnull
    private final String paymentBatchId;

    /**
     * Идентификатор платежа.
     */
    @Nullable
    private final String trustPaymentId;

    /**
     * Идентификатор возврата.
     */
    @Nullable
    private final String trustRefundId;

    /**
     * Абсолютная величина суммы заказа (строчки в корзине), в валюте ПП.
     */
    private final BigDecimal sum;

    /**
     * Валюта ПП.
     */
    @Nonnull
    private final BillingCurrency currency;

    /**
     * Метод оплаты.
     */
    @Nullable
    private final PaymentType paymentType;

    /**
     * Тип транзакции.
     */
    @Nonnull
    private final TransactionType transactionType;

    /**
     * Дата передачи в OEBS.
     */
    @Nonnull
    private final LocalDate handlingTime;

    /**
     * Дата совершения операции.
     */
    @Nonnull
    private final LocalDate paymentTime;

    /**
     * Идентификатор договора с партнером.
     */
    @Nullable
    private final Long contractId;

    /**
     * Идентификатор заказа на сервисе.
     */
    @Nullable
    private final String serviceOrderId;

    /**
     * Величина агентского вознаграждения.
     */
    @Nullable
    private final BigDecimal agencyCommission;
}
